/*
 * Decompiled with CFR 0.152.
 */
package mlsoft.mct;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Toolkit;
import mlsoft.mct.MlUtil;

class MlTab {
    public int x;
    public int y;
    public int width;
    public int height;
    public Component parent;
    public Component pageComponent;
    public String pageName;
    public String label;
    public Font font;
    public int labelX;
    public int labelY;
    public int labelWidth;
    public int labelHeight;
    public Image image;
    public int imageHeight;
    public int imageWidth;
    public Image inactiveImage;
    public int inactiveImageHeight;
    public int inactiveImageWidth;
    public boolean firstInRow;
    public int maxImageWidth;
    public int maxImageHeight;
    public int row;

    public MlTab(Component component) {
        this.parent = component;
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
        this.labelWidth = 0;
        this.labelHeight = 0;
        this.firstInRow = false;
        this.maxImageWidth = 0;
        this.maxImageHeight = 0;
        this.row = -1;
    }

    protected void recalcLabelDimensions() {
        if (this.label == null || this.font == null) {
            this.labelWidth = 0;
            this.labelHeight = 0;
            return;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.labelHeight = fontMetrics.getHeight();
        this.labelWidth = fontMetrics.stringWidth(this.label);
    }

    public void setFont(Font font) {
        this.font = font;
        this.recalcLabelDimensions();
    }

    public void setLabel(String string) {
        this.label = string;
        this.recalcLabelDimensions();
    }

    protected void recalcMaxImages() {
        this.maxImageWidth = this.imageWidth > this.inactiveImageWidth ? this.imageWidth : this.inactiveImageWidth;
        if (this.imageHeight > this.inactiveImageHeight) {
            this.maxImageHeight = this.imageHeight;
            return;
        }
        this.maxImageHeight = this.inactiveImageHeight;
    }

    public void setImage(Image image) {
        this.image = image;
        if (image == null) {
            this.imageWidth = 0;
            this.imageHeight = 0;
        } else {
            Dimension dimension = MlUtil.getImageDimensions(image, this.parent);
            this.imageWidth = dimension.width;
            this.imageHeight = dimension.height;
        }
        this.recalcMaxImages();
    }

    public void setInactiveImage(Image image) {
        this.inactiveImage = image;
        if (image == null) {
            this.inactiveImageWidth = 0;
            this.inactiveImageHeight = 0;
        } else {
            Dimension dimension = MlUtil.getImageDimensions(image, this.parent);
            this.inactiveImageWidth = dimension.width;
            this.inactiveImageHeight = dimension.height;
        }
        this.recalcMaxImages();
    }
}

